#include <assert.h>



inline int mod(const int x, const int y){
	return (x+y)&(y-1);
}

void square(int * surface, int x, int y, int dis, int width ){

	int height;
	int mod = width-1;
	int nx,ny;
	
	height=surface[x-dis+(y-dis)*width];

	ny=(y+dis)&mod;
	height+=surface[x-dis+ny*width];

	nx=(x+dis)&mod;
	height+=surface[nx+(y-dis)*width];

	height+=surface[nx+ny*width];

	height/=4;
	height+=(rand()%dis)-dis/2;
	surface[x+y*width]=height;
}


void diamond(int * surface, int x, int y, int dis, int width ){
	int height;
	int mod = width-1;
	int n;

	n=(width+x-dis)&mod;
	height=surface[n+y*width];

	n=(x+dis)&mod;
	height+=surface[n+y*width];

	n=(width+y-dis)&mod;
	height+=surface[x+n*width];

	n=(y+dis)&mod;
	height+=surface[x+n*width];

	height/=4;
	height+=(rand()%dis)-dis/2;
	surface[x+y*width]=height;
}

void midpoint_displacement(int * surface, int width ){

	unsigned int stepping=width/2;
	while ( stepping ){
		unsigned int x;
		unsigned int y;
		for (y=stepping;y<width;y+=stepping*2){
			for (x=stepping;x<width;x+=stepping*2){
				square(surface,x,y,stepping,width);
			}
		}
		for (y=0;y<width;y+=stepping){
			for (x=((y/stepping)%2)?0:stepping;x<width;x+=stepping*2){
				diamond(surface,x,y,stepping,width);
			}
		}
		stepping/=2;
	}
}

void blur(int * src, int w){

	static int * temp = 0;
	if ( !temp ){
		temp = (int *)malloc(1024*1024*4);
	}

	int y;
	int x;
	int sum;
	int sqr=w*w;
	int and=w-1;
	for ( y=0;y<w;y++){
		for ( x=0;x<w;x++){
			sum=src[((x-1+w)&and)+((y-1+w)&and)*w];
			sum+=src[x+((y-1+w)&and)*w];
			sum+=src[((x+1)&and)+((y-1+w)&and)*w];
			sum+=src[((x-1+w)&and)+y*w];
			sum+=src[((x+1)&and)+y*w];
			sum+=src[((x-1+w)&and)+((y+1)&and)*w];
			sum+=src[x+((y+1)&and)*w];
			sum+=src[((x+1)&and)+((y+1)&and)*w];
			temp[x+y*w]=sum/8;
		}
	}
	memcpy(src,temp,w*w*4);
}

void blur(float * src, int w){

	static float * temp = 0;
	if ( !temp ){
		temp = (float *)malloc(1024*1024*4);
	}

	int y;
	int x;
	float sum;
	int sqr=w*w;
	int and=w-1;
	for ( y=0;y<w;y++){
		for ( x=0;x<w;x++){
			sum=src[((x-1+w)&and)+((y-1+w)&and)*w];
			sum+=src[x+((y-1+w)&and)*w];
			sum+=src[((x+1)&and)+((y-1+w)&and)*w];
			sum+=src[((x-1+w)&and)+y*w];
			sum+=src[((x+1)&and)+y*w];
			sum+=src[((x-1+w)&and)+((y+1)&and)*w];
			sum+=src[x+((y+1)&and)*w];
			sum+=src[((x+1)&and)+((y+1)&and)*w];
			temp[x+y*w]=sum/8;
		}
	}
	memcpy(src,temp,w*w*4);
}

void brownian(unsigned int * texture, const int dim,const int particles){

	const int steps[]={1,0, 1,1, 0,1, -1,1, -1,0, -1,-1, 0,-1, 1,-1};
 for ( int count=0;count<particles;count++){
		int x = rand()%dim;
		int y=rand()%dim;

		while (    !texture[mod(x-1,dim)+mod(y-1,dim)*dim] && !texture[x+mod(y-1,dim)*dim] && !texture[mod(x+1,dim)+mod(y-1,dim)*dim] &&
					!texture[mod(x-1,dim)+y*dim] && !texture[x+y*dim] && !texture[mod(x+1,dim)+y*dim] && 
					!texture[mod(x-1,dim)+mod(y+1,dim)*dim] && !texture[x+mod(y+1,dim)*dim] && !texture[mod(x+1,dim)+mod(y+1,dim)*dim] ){

			int index=rand()&7;
			x+=steps[index*2];
			y+=steps[index*2+1];

			if ( x > dim-1 ){
				x=0;
			} else if ( x<0 ){
				x=dim-1;
			}
			if ( y > dim-1 ){
					y=0;
			}
			if ( y<0 ){
				y=dim-1;
			}
		}
		texture[x+y*dim]=255;
	}
}

void brownian_tridux(unsigned int * src, const int dim){

	int steps[]={1,0, 1,1, 0,1, -1,1, -1,0, -1,-1, 0,-1, 1,-1};
	unsigned int count=0xffffffff;
	src[dim/2+dim*dim-dim]=0xffffffff;
	for ( int sdim=16;sdim<dim-8;sdim+=2){
		while ( true ){
			int x = rand()%sdim+(dim-sdim)/2;
			int y=dim-sdim+1;
			int px;
			int py;

			while ( !src[x+y*dim-dim-1] && !src[x+y*dim-dim] && !src[x+y*dim-dim+1]
					&& !src[x+y*dim-1] && !src[x+y*dim+1]
					&& !src[x+y*dim+dim-1] && !src[x+y*dim+dim] && !src[x+y*dim+dim+1]){
				px=x;
				py=y;
				int index=rand()&7;
				x+=steps[index*2];
				y+=steps[index*2+1];

				if ( x >= (dim+sdim)/2 ){
					x=px;
				} else if ( x<(dim-sdim)/2 ){
					x=px;
				}
				if ( y > dim-1 ){
					y=dim-sdim;
				}
				if ( y<dim-sdim ){
					y=py;
				}
			}
			count--;
			src[x+y*dim]=count;
			if ( y<=dim-sdim+3 ){
				break;
			}

		}
	}
}


DWORD WINAPI thor( LPVOID i ){
	
		unsigned int * temp=(unsigned int *)malloc(l_size*l_size*4);

	while (true ){
		do {
			_sleep(200);
		} while (strike);

		memset(lightning,0,l_size*l_size*4);
		brownian_tridux(lightning,l_size);
		
		int x,y;
		for ( int a=0;a<l_size*l_size;a++){
			if( lightning[a]){
				x=a%l_size;
				y=a/l_size;
				break;
			}
		}
		while ( y<l_size-1){
			lightning[x+y*l_size]=0xff;
			int max_val=0;
			int i,j;
			for ( int y1=-1;y1<=1;y1++){
				for ( int x1=-1;x1<=1;x1++){
					if ( lightning[x+x1+(y+y1)*l_size]>max_val ){
						max_val=lightning[x+x1+(y+y1)*l_size];
						i=x1;
						j=y1;
					}
				}
			}
			x+=i;
			y+=j;
		}
		for ( int c=255;c;c--){
			for ( a=0;a<l_size*l_size;a++){
				if( lightning[a]==c){
					for ( y=-1;y<=1;y++){
						for ( x=-1;x<=1;x++){
							if ( lightning[x+y*l_size+a] >255 ){
								lightning[x+y*l_size+a]=c-1;
							}
						}
					}
				}
			}
		}
		for ( a=0;a<l_size*l_size;a++){
			if ( lightning[a] > 255 ){
				lightning[a]=0;
			}
		}

		for ( y=1;y<l_size-1;y++){
			for ( x=1;x<l_size-1;x++){
				if ( lightning[x+y*l_size] && lightning[x+y*l_size]<255 ){
					int counter=0;
					counter+=lightning[x+y*l_size-l_size-1]>0;
					counter+=lightning[x+y*l_size-l_size]>0;
					counter+=lightning[x+y*l_size-l_size+1]>0;
					counter+=lightning[x+y*l_size-1]>0;
					counter+=lightning[x+y*l_size+1]>0;
					counter+=lightning[x+y*l_size+l_size-1]>0;
					counter+=lightning[x+y*l_size+l_size]>0;
					counter+=lightning[x+y*l_size+l_size+1]>0;
					if ( counter <2 ){
						int py=y;
						int px=x;
						while ( lightning[x+y*l_size]<255){
							lightning[x+y*l_size]|=256;
							int max_val=0;
							int i,j;
							for ( int y1=-1;y1<=1;y1++){
								for ( int x1=-1;x1<=1;x1++){
									if ( (lightning[x+x1+(y+y1)*l_size]&255)>max_val ){
										max_val=lightning[x+x1+(y+y1)*l_size]&255;
										i=x1;
										j=y1;
									}
								}
							}
							x+=i;
							y+=j;
						}
						x=px;
						y=py;
					}
				}
			}
		}

		for ( a=0;a<l_size*l_size;a++){
			if ( lightning[a] < 255 ){
				lightning[a]=0;
			} else {
				lightning[a]&=255;
			}
		}

		memset(temp,0,l_size*l_size*4);
		for ( x=0;x<2;x++){
			for ( a=0;a<l_size*l_size;a++){
				temp[a]+=lightning[a];
			}
			blur((int*)temp,l_size);
		}

		for ( x=0;x<16;x++){
			blur((int*)temp,l_size);
			for ( a=0;a<l_size*l_size;a++){
				if ( temp[a] )
					temp[a]+=4;
			}
		}

		memset(lightning,0,l_size*8*4);

		for ( a=l_size*8;a<l_size*l_size;a++){
			if ( temp[a] ){
				unsigned int c=temp[a];
				unsigned int d=lightning[a];
				unsigned int rr=c*.9;
				unsigned int gg=(unsigned int)c*.4;
				unsigned int bb=(unsigned int)c;
				unsigned int aa=(unsigned int)c;
				rr+=d;
				gg+=d;
				bb+=d;
				aa+=d;
				rr=min(rr,255);
				gg=min(gg,255);
				bb=min(bb,255);
				aa=min(aa,255);
				c=rr+(gg<<8)+(bb<<16)+(aa<<24);
				lightning[a]=c;
			}
		}

		strike=bolt_time;
	}
}
