
void midpoint_blur(int * surface, unsigned int dimension);
void midpoint_displacement(int * surface, int width );

void min_max(int * surface, int dim,int &low, int &high){
	low=0;
	high=0;
	for ( int a=0;a<dim*dim;a++){
		if ( surface[a] < low ){
			low = surface[a];
		}
		if ( surface[a] > high ){
			high = surface[a];
		}
	}
}

#include <windows.h>
#include <stdio.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>
#include <math.h>
#include <stdlib.h>
#include <memory.h>
#include "GLext.h"
#include "time.h"
#include "bmpfunctions.h"

#define GL_COMBINE_ARB 0x8570
#define GL_RGB_SCALE_ARB 0x8573

void play_thunder(int distance);

const bool fog = true;
const bool clouds = true;
const bool rain = true;

const bool wireframe=false;

const bool useLightning=true;

const bool use_texture=true;

const bool use_color=true;

const float amb = (float)0.45;
float amb_mod=0;

bool space = false;

int frame =0;
int fps = 30;
unsigned char * frame_buffer;

PFNGLMULTITEXCOORD2FARBPROC	glMultiTexCoord2fARB	= NULL;
PFNGLACTIVETEXTUREARBPROC	glActiveTextureARB	= NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC	glClientActiveTextureARB= NULL;

#pragma warning(disable:4305)
#pragma warning(disable:4018)
#pragma warning(disable:4244)
#pragma warning(disable:4101)
#pragma warning(disable:4731)

volatile int strike=0;

float strike_angle=0;
float strike_dis=0;
float strike_x;
float strike_z;

#define PI 3.1415926535
#define TO_RAD	*(3.1415926535/180.0)
#define deg *(3.1415926535/180.0)

const int terr_size=1024;
const int view_dis=1024;
const int tex_size=512;
const int l_size=512;
const int LOD =16;
const float fov=50;
const int bolt_time=25;

float xpos=0,ypos=0,zpos=0;
float rvert=0;
float rhor=0;
unsigned int mousex, mousey;
unsigned int centerx, centery;

unsigned int * lightning;
unsigned int * lbuffer;
float * terrain;
int * terr_shade;
int tmin=0xffff;
int tmax=0;
float tscale=1;

#include "midpoint_displace.cpp"

unsigned char * view_map;
float orig_bg[4] = {55/275.0,75/275.0,100/275.0, 1};
float background[4]= {55/275.0,75/275.0,100/275.0, 1};
#define GRASS 1
#define CLOUD1 2
#define CLOUD2 3
#define CLOUD3 4
#define CRACKS 5
#define LIGHTNING 6

HDC			hDC=NULL;
HGLRC		hRC=NULL;
HWND		hWnd=NULL;
HINSTANCE	hInstance;

bool	keys[256];
bool	fullscreen=TRUE;

int cloud_height=0;

LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
void CheckMouse();

#include "init.cpp"

inline int mod(const int x){
	return (x+terr_size)&(terr_size-1);
}

inline int mod_tex(const int x){
	return (x+tex_size)&(tex_size-1);
}

inline float radian(float x){
	return x*PI/180.0;
}

int min4(int x,int y,int z,int a){
	if ( y < x ) x=y;
	if ( z < x ) x=z;
	if ( a < x ) x=a;
	return x;
}

int max4(int x,int y,int z, int a){
	if ( y > x ) x=y;
	if ( z > x ) x=z;
	if ( a > x ) x=a;
	return x;
}

void Resize(GLsizei width, GLsizei height){
	centerx=width/2;
	centery=height/2;
	mousex=centerx;
	mousey=centery;
	glViewport(0,0,width,height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(fov,(GLfloat)width/(GLfloat)height,.5,view_dis);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

}

void draw_bolt(){

	glEnable(GL_TEXTURE_2D);
	glDisable(GL_FOG);
	glEnable(GL_BLEND);
	glBlendFunc(GL_DST_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	glBindTexture(GL_TEXTURE_2D, LIGHTNING );

	if ( strike==bolt_time ){
		
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
 		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
		gluBuild2DMipmaps(GL_TEXTURE_2D, 4, l_size, l_size,  GL_RGBA, GL_UNSIGNED_BYTE, lightning);
		strike_dis=rand()%view_dis;
		strike_dis*=2;
		strike_dis/=3;
		strike_dis+=8;
		strike_angle=rand()%(int)fov-fov/2+rhor;
		strike--;
		strike_x=xpos;
		strike_z=zpos;

	}

	if ( strike == bolt_time-6 && rand()%8==0){
		strike=bolt_time-1;
	}

	glPushMatrix();

	float ym = cloud_height-128-64;
	glTranslatef(strike_x,ym,strike_z);
	glRotatef(-strike_angle,0,1,0);

	float sx=-64;
	float sz=-strike_dis;

	
	GLfloat LightPosition[]= { 0, cloud_height-64-32, sz, 1 };
	GLfloat LightDirection[]={0,1,0,0};
	float lc = (strike-bolt_time+7)/7.0*.75;
	if ( strike <= bolt_time-7 ){
		lc=0;
	}
	float am = lc/2;//(strike-10)/(float)(bolt_time-10);

	am*=strike_dis/(float)view_dis;
	am*=.5;
	amb_mod=am;
	GLfloat LightAmbient[]= { 0,0,0,1 };
	GLfloat LightDiffuse[]= { lc, lc, lc, 1 };
	glLightfv(GL_LIGHT0, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT0, GL_POSITION,LightPosition);
	glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, .0001);
	glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, .001);

	glEnable(GL_LIGHT0);

	glBegin(GL_QUADS);
	float c=strike/((float)bolt_time);
	if ( c == 1 ){
		c = .5;
	}

	glColor4f(1,1,1,c);
	int step=8;
	for ( int a=0;a<3;a++){
		for ( int y=0;y<128;y+=step){
			for ( int x=0;x<128;x+=step){
				glTexCoord2f(x/128.0,y/128.0);
				glVertex3f(x+sx,y,sz);
				glTexCoord2f((x+step)/128.0,y/128.0);
				glVertex3f(x+sx+step,y,sz);
				glTexCoord2f((x+step)/128.0,(y+step)/128.0);
				glVertex3f((x+sx)+step,y+step,sz);
				glTexCoord2f((x)/128.0,(y+step)/128.0);
				glVertex3f((x+sx),y+step,sz);
			}
		}
		sz+=1/4.0;
	}


	glEnd();

	glPopMatrix();
	
	glEnable(GL_FOG);

	float fogc[4];
	background[0]=orig_bg[0]*(1.0+am);
	background[1]=orig_bg[1]*(1.0+am);
	background[2]=orig_bg[2]*(1.0+am);
	background[3]=orig_bg[3];
	glFogfv (GL_FOG_COLOR, &background[0]);

	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	strike--;
	if ( !strike ){

		background[0]=orig_bg[0];
		background[1]=orig_bg[1];
		background[2]=orig_bg[2];
		glFogfv(GL_FOG_COLOR, &orig_bg[0]);
		glDisable(GL_LIGHT0);
	}
}

void __stdcall terr_vert(int _dx, int _dz, int step){

	const float tex_scale=512*24;
	const float tex_scale2=32.0;

	int pos = mod(_dx)+mod(_dz)*terr_size;

	//glColor3f(1,1,1);

	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,_dx/tex_scale,_dz/tex_scale);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,_dx/tex_scale2,_dz/tex_scale2);

	glColor3ubv((unsigned char *)(terr_shade+pos));


	glVertex3f(_dx,terrain[pos],_dz);



	pos = mod(_dx)+mod(_dz+step)*terr_size;

	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,_dx/tex_scale,(_dz+step)/tex_scale);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,_dx/tex_scale2,(_dz+step)/tex_scale2);

	glColor3ubv((unsigned char *)(terr_shade+pos));

	glVertex3f(_dx,terrain[pos],_dz+step);
}

int Display(){

	CheckMouse();

	glClearColor(background[0],background[1],background[2],0);
	glFogfv(GL_FOG_COLOR, &background[0]);
	glEnable(GL_FOG);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	glRotatef(rvert,1,0,0);
	glRotatef(rhor,0,1,0);

	glTranslatef(-xpos,ypos,-zpos);

	GLfloat LightAmbient[]= { .5,.5,.5,1 };
	LightAmbient[0]=amb+amb_mod;
	LightAmbient[1]=amb+amb_mod;
	LightAmbient[2]=amb+amb_mod;
	
	glEnable(GL_COLOR_MATERIAL);
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, LightAmbient);

	glEnable(GL_LIGHTING);

	int x;
	int z;

	int start_x,end_x;
	int start_z,end_z;
	
	//0.698131701 = 40 in radian
	//0.0174532925 = PI / 180
	int z1=cos(radian(-rhor+40+180))*(view_dis-1);
	int x1=sin(radian(-rhor+40+180))*(view_dis-1);

	int z2=cos(radian(-rhor-40+180))*(view_dis-1);
	int x2=sin(radian(-rhor-40+180))*(view_dis-1);

	int z3=cos(radian(-rhor+180))*(view_dis-1);
	int x3=sin(radian(-rhor+180))*(view_dis-1);

	start_x=min4(0,x1,x2,x3);
	start_z=min4(0,z1,z2,z3);
	end_x=max4(0,x1,x2,x3);
	end_z=max4(0,z1,z2,z3);

	if ( abs(rvert) > 55 ){
		start_x=-256-LOD*2;
		end_x=256+LOD*2;
		start_z=-256-LOD*2;
		end_z=256+LOD*2;
	} else {
		if ( start_x == 1024 )
			start_x-=LOD;
		if ( start_z == -1044 )
			start_z+=LOD;
		if ( end_x == 1024)
			end_x-=LOD;
		if ( end_z == -1024 )
			end_z+=LOD;
		if ( abs(start_x) < abs(end_x) ){
			if ( end_x<=0 )
				start_x+=LOD;
			else
				start_x-=LOD;
		} else {
			if ( start_x<=0 )
				end_x+=LOD;
			else
				end_x-=LOD;
		}

		if ( abs(start_z) < abs(end_z) ){
			if ( end_z<=0 )
				start_z +=LOD;
			else
				start_z-=LOD;
		} else {
			if ( start_z<=0 )
				end_z+=LOD;
			else
				end_z-=LOD;
		}
	}

	int xp=xpos/LOD;
	int zp=zpos/LOD;
	xp*=LOD;
	zp*=LOD;

	start_x/=LOD;
	start_x*=LOD;
	start_z/=LOD;
	start_z*=LOD;

	end_x/=LOD;
	end_x*=LOD;
	end_z/=LOD;
	end_z*=LOD;
	glDisable(GL_BLEND);


	glScalef(1,2/4.0,1);

	// TEXTURE-UNIT #0
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, GRASS);
	//glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
	glTexEnvf (GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_REPLACE);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
 	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);

	// TEXTURE-UNIT #1
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);

	glBindTexture(GL_TEXTURE_2D, CRACKS);
	//glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
	glTexEnvf (GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_INCR);
	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
 	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);
	
	

	glNormal3f(0,1,0);

	for ( int step=LOD; step>=1;step/=2){
	

		for ( z=start_z;z<end_z;z+=step){
			int jumper=1;
			int x=start_x;
lable_1:
			for ( ;x<end_x && view_map[abs(x)+abs(z*view_dis)]!=step;x+=step);
			if ( x>=end_x){
				continue;
			}
			x-=step;
			int dx=x+xp;
			int dz=z+zp;
			glBegin(GL_TRIANGLE_STRIP);

			terr_vert(dx-step*2,dz,step);

			terr_vert(dx-step,dz,step);

			terr_vert(dx,dz,step);
			x+=step;
			for ( ;x<end_x && (view_map[abs(x)+abs(z*view_dis)]==step
					|| view_map[abs(x-step)+abs(z*view_dis)]==step
					|| view_map[abs(x+step)+abs(z*view_dis)]==step
					|| view_map[abs(x)+abs((z-step)*view_dis)]==step
					|| view_map[abs(x)+abs((z+step)*view_dis)]==step);x+=step){
				dx=x+xp;
				terr_vert(dx,dz,step);
			}
			dx=x+xp;
			terr_vert(dx,dz,step);

			glEnd();

			if ( jumper ){
				jumper--;
				goto lable_1;
			}
		}
	}
	
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);
	
	

	glScalef(1,1/2.0*4,1);

	if ( clouds ){
		glNormal3f(0,-1,0);
		glEnable(GL_BLEND);
		glEnable(GL_TEXTURE_2D);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		
		float height=cloud_height;

		float dx=(float)frame/fps/40.0;
		float dz=0;
		float cloud_size=512;
		float alpha=.9;
		glDisable(GL_BLEND);
		for ( int a=0;a<3;a++){
			glColor4f(1,1,1,alpha+.1);
			glBindTexture(GL_TEXTURE_2D, a+2 );
			glBegin(GL_QUADS);
			const int csize=16;
			for ( z=start_z+zp-csize;z<end_z+zp;z+=csize){
				for ( int x=start_x+xp-csize;x<end_x+xp;x+=csize){
					//float height=256;
					glTexCoord2f(x/cloud_size+dx,z/cloud_size+dz);
					glVertex3f(x,height,z);
					glTexCoord2f((x+csize)/cloud_size+dx,z/cloud_size+dz);
					glVertex3f(x+csize,height,z);
					glTexCoord2f((x+csize)/cloud_size+dx,(z+csize)/cloud_size+dz);
					glVertex3f(x+csize,height,(z+csize));
					glTexCoord2f(x/cloud_size+dx,(z+csize)/cloud_size+dz);
					glVertex3f(x,height,(z+csize));
				}
			}
			glEnd();
			height-=32;
			dx*=1.79;
			if ( dz >=0 ){
				dz=dx/-3.0;
			} else {
				dz=dx/3.0;
			}
			cloud_size*=.67;
			alpha*=alpha;
			glEnable(GL_BLEND);
		}
	}

	if ( strike ){
		draw_bolt();
	}

	if ( rain ){
		glDisable(GL_TEXTURE_2D);

		glPushMatrix();
		glTranslatef(xpos,-ypos,zpos);
		glRotatef(-rhor,0,1,0);
		glBegin(GL_QUADS);
		glNormal3f(0,0,-1);
		glColor4f(100/150.0,137/150.0,196/150.0,.4);

		// rain
		for ( int a=0;a<4000;a++){
			float x=(rand()%(2048*8))/64.0/4;
			float z=(rand()%(2048*8))/64.0/4;
			float y=(rand()%(2048*8))/64.0/4;
			x-=16;
			y-=16;
			z-=64;
			if ( rvert>45 || rvert<-45){
				z+=16;
			}
			glVertex3f(x,y,z);
			glVertex3f(x+.04,y+.04,z);
			glVertex3f(x,y+.4,z);
			glVertex3f(x-.04,y+.04,z);

		}

		glEnd();

		glPopMatrix();
	}

	frame++;
	//glReadPixels(0, 0, 1024, 768, GL_BGR_EXT, GL_UNSIGNED_BYTE, frame_buffer);
	//char msg[100];
	//sprintf(msg,"frame_%d.bmp",frame);
	//WriteBmp(frame_buffer,msg, 1024,768);

	return 1;
}

void midpoint_blur(int * surface, unsigned int dimension){
	*surface=0;
	midpoint_displacement(surface,dimension);
	blur(surface,dimension);
}

void midpoint_blur2(float * surface, unsigned int dimension){
	*surface=0;
	midpoint_displacement((int*)surface,dimension);
	for ( int x=0;x<dimension*dimension;x++){
		surface[x]=*(int*)&surface[x];
	}	
	blur(surface,dimension);
}

int InitGL(GLvoid){

	frame_buffer = (unsigned char *)malloc(1024*768*4);

	int a;

	glShadeModel(GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	glFogi(GL_FOG_MODE, GL_LINEAR);		// Fog Mode
	glFogf(GL_FOG_END, view_dis*.87);		// Fog End Depth
			
	srand(time(0));


	//glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    //glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    //glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
 	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR);

    //glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	terrain=(float *)malloc(terr_size*terr_size*4);
	terr_shade=(int *)malloc(terr_size*terr_size*4);

	int * scratch=(int *)malloc(tex_size*tex_size*4);
	unsigned char * texture=(unsigned char *)malloc(tex_size*tex_size*4);
	view_map=(unsigned char *)malloc(view_dis*view_dis);
	lightning=(unsigned int *)malloc(l_size*l_size*4);
	lbuffer=(unsigned int *)malloc(tex_size*tex_size*4);

	set_viewmap();

	midpoint_blur2(terrain,terr_size);

	init_cracks(lightning,texture);

	glBindTexture(GL_TEXTURE_2D, CRACKS );
	gluBuild2DMipmaps(GL_TEXTURE_2D, 4, tex_size, tex_size,  GL_RGBA, GL_UNSIGNED_BYTE, texture);

	init_grass(texture,scratch, lightning);

	glBindTexture(GL_TEXTURE_2D, GRASS );
	gluBuild2DMipmaps(GL_TEXTURE_2D, 4, tex_size, tex_size,  GL_RGBA, GL_UNSIGNED_BYTE, texture);

	init_clouds(texture,scratch);

	char *extensions;
	extensions=strdup((char *) glGetString(GL_EXTENSIONS));
	if ( !strstr(extensions,"GL_ARB_multitexture") ){
		exit(0);
	}


	glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC) wglGetProcAddress("glMultiTexCoord2fARB");
	glActiveTextureARB   = (PFNGLACTIVETEXTUREARBPROC) wglGetProcAddress("glActiveTextureARB");
	glClientActiveTextureARB= (PFNGLCLIENTACTIVETEXTUREARBPROC) wglGetProcAddress("glClientActiveTextureARB");

	for ( int x=0;x<terr_size*terr_size;x++){
		unsigned int d = rand()&255;

		terr_shade[x]=d;
	}

	for ( a=0;a<terr_size*terr_size;a++){
		if ( terrain[a]>tmax){
			tmax=terrain[a];
		}
		if ( tmin > terrain[a] ){
			tmin=terrain[a];
		}
	}

	cloud_height = 256;
	tscale = 450/(tmax-tmin);
	for ( a=0;a<terr_size*terr_size;a++){
		terrain[a]-=tmin;
		terrain[a]*=tscale;
	}


	srand(time(0));
	for ( a=0;a<terr_size*terr_size;a++){
		int r=rand()%16-15+255;
		int g=rand()%16-15+255;
		int b=rand()%16-15+255;

		unsigned int d = (r)|(g<<8)|(b<<16);
		terr_shade[a]=d;
	}

	ypos = -terrain[0]/2-15;

	free(texture);
	free(scratch);

	return TRUE;
}

#include "window_functions.cpp"
int WINAPI WinMain(	HINSTANCE	hInstance,			// Instance
					HINSTANCE	hPrevInstance,		// Previous Instance
					LPSTR		lpCmdLine,			// Command Line Parameters
					int			nCmdShow)			// Window Show State
{

	MSG		msg;									// Windows Message Structure
	BOOL	done=FALSE;								// Bool Variable To Exit Loop

	fullscreen=1;

	// Create Our OpenGL Window
	if (!CreateGLWindow("Lightning",1024,768,32,fullscreen)){
		return 0;
	}

	if ( useLightning ){
		unsigned long temp;
		CreateThread(NULL,0,thor,0,0,&temp);
	}

	while(!done){
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)){
			if (msg.message==WM_QUIT){
				done=TRUE;
			} else {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		} else {
			// Draw The Scene.  Watch For ESC Key		
			if ( keys[VK_ESCAPE]){
				done=TRUE;
			} else {
				Display();
				SwapBuffers(hDC);
			}
		}
	}

	// Shutdown
	//KillGLWindow();									// Kill The Window
	return (msg.wParam);							// Exit The Program
}
