
void midpoint_displacement(int * surface, int width );

void bind_texture(unsigned char * tex,int bind_num){
	glBindTexture(GL_TEXTURE_2D, bind_num );
	gluBuild2DMipmaps(GL_TEXTURE_2D, 4, tex_size, tex_size,  GL_RGBA, GL_UNSIGNED_BYTE, tex);
}

void init_grass(unsigned char * texture, int * scratch, unsigned int * lightning){

	int x;

	for ( x=0;x<tex_size*tex_size;x++){
		int r = 165-16;
		int g = 206-16;
		int b = 48-32;
		r+=rand()%48;
		g+=rand()%48;
		b+=rand()%32;

		texture[x*4+0]=r;
		texture[x*4+1]=g;
		texture[x*4+2]=b;
		texture[x*4+3]=255;
	}
}

void init_clouds(unsigned char * texture, int * scratch){
	
	for ( int a =0; a< 3;a++){
		scratch[0]=0;
		((int*)texture)[0]=0;

		int amin,amax;
		int cmin,cmax;
		midpoint_displacement(scratch,tex_size);
		midpoint_displacement((int*)texture,tex_size);
		min_max(scratch,tex_size,amin,amax);
		min_max((int*)texture,tex_size,cmin,cmax);
		
		cmin-=64;
		cmax+=64;

		for ( int x=0;x<tex_size*tex_size;x++){
			int alpha=(scratch[x]-amin)*255/(amax-amin);
			if ( alpha<0){
				alpha=0;
			} else if (	alpha > 255){
				alpha=255;
			}

			int c = (((int*)texture)[x]-cmin)*255/(cmax-cmin);
			if ( c<0 ){
				c=0;
			}
			if ( c > 255 ){
				c=255;
			}
			texture[x*4+0]=c;
			texture[x*4+1]=c;
			texture[x*4+2]=c;
			texture[x*4+3]=alpha;
		}
		glBindTexture(GL_TEXTURE_2D, a+2 );
		gluBuild2DMipmaps(GL_TEXTURE_2D, 4, tex_size, tex_size,  GL_RGBA, GL_UNSIGNED_BYTE, texture);
	}
}

void set_viewmap(){

	memset(view_map,0,view_dis*view_dis);

	for ( int step=LOD; step>=1;step/=2){
		int dis=view_dis*step/LOD;
		for ( double r=0;r<PI/2;r+=.001){
			int y=cos(r)*(dis);
			int x=sin(r)*(dis);

			int y_end=y+step;

			if ( y_end < view_dis){
				for (;y<y_end;y++){
					int start=0;
					for ( ;start<x;start++){
						view_map[start+y*view_dis]=step;
					}
				}
			}
		}
	}
}

void init_cracks(unsigned int * light, unsigned char * tex){
	
	memset(light,0,tex_size*tex_size*4);
	for ( int a=0;a<256/2;a++){
		int x=rand()%tex_size;
		int y=rand()%tex_size;
		light[x+y*tex_size]=0xffffffff;
	}
	
	brownian(light,tex_size,1024*96);

	for (a=tex_size*tex_size-1;a>=0;a--){
		tex[a*4+0]=rand()%64;
		tex[a*4+1]=rand()%64;
		tex[a*4+2]=rand()%64;
		if (light[a]){
			tex[a*4+0]+=150;
			tex[a*4+1]+=150;
			tex[a*4+2]+=150;
			tex[a*4+3]=0;
		} else {
			tex[a*4+0]+=255-64;
			tex[a*4+1]+=255-64;
			tex[a*4+2]+=255-64;
			tex[a*4+3]=255;
		}
	}
}