#include "bmpfunctions.h"

#include <stdio.h>
#include <windows.h>
#include <memory.h>
#include <stdlib.h>

void WriteBmp(const unsigned char * const in,char * filename, int width, int height ){
	unsigned char header[54];
	memset(header,0,54);

	header[0]='B';
	header[1]='M';

	*(long*)(header+2)=width*height*3+54;
	*(long*)(header+10)=54;
	*(long*)(header+14)=0x28;
	*(long*)(header+18)=width;
	*(long*)(header+22)=height;
	*(short*)(header+26)=1;
	*(short*)(header+28)=24;
	*(long*)(header+34)=width*height*3;
	
	HANDLE file = CreateFile(filename,GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,0,NULL);
	unsigned long bytes;
	WriteFile(file, header,54,&bytes,NULL);
	WriteFile(file, in, width*height*3, &bytes, NULL );
	
	CloseHandle(file);
}

void WriteBmp32(const unsigned int * const in,char * filename, int width, int height ){
	WriteBmp32((const unsigned char * const)in, filename, width, height);
}

void WriteBmp32(const unsigned char * const in,char * filename, int width, int height ){
	unsigned char header[54];
	memset(header,0,54);

	header[0]='B';
	header[1]='M';

	*(long*)(header+2)=width*height*4+54;
	*(long*)(header+10)=54;
	*(long*)(header+14)=0x28;
	*(long*)(header+18)=width;
	*(long*)(header+22)=height;
	*(short*)(header+26)=1;
	*(short*)(header+28)=32;
	*(long*)(header+34)=width*height*4;
	
	HANDLE file = CreateFile(filename,GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,0,NULL);
	unsigned long bytes;
	WriteFile(file, header,54,&bytes,NULL);
	WriteFile(file, in, width*height*4, &bytes, NULL );
	
	CloseHandle(file);
}

void WriteGreyscaleBmp(const unsigned char * const in,char * filename, int width, int height, int length ){
	unsigned char header[54];
	memset(header,0,54);

	header[0]='B';
	header[1]='M';

	*(long*)(header+2)=width*height*3+54;
	*(long*)(header+10)=54;
	*(long*)(header+14)=0x28;
	*(long*)(header+18)=width;
	*(long*)(header+22)=height;
	*(short*)(header+26)=1;
	*(short*)(header+28)=24;
	*(long*)(header+34)=width*height*3;

	HANDLE file = CreateFile(filename,GENERIC_WRITE,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,0,NULL);
	unsigned long bytes;
	WriteFile(file, header,54,&bytes,NULL);
	unsigned char * temp = (unsigned char *)malloc(width*height*3);
	memset(temp,0,width*height*3);
	for ( int a=0;a<length;a++){
		temp[a*3]=in[a];
		temp[a*3+1]=in[a];
		temp[a*3+2]=in[a];
	}
	WriteFile(file,temp,width*height*3,&bytes,NULL);
	CloseHandle(file);
}

int ReadBMP(char * filename, int &width, int &height, unsigned char * &data){
	unsigned char header[54];
	HANDLE file = CreateFile( filename, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
	if ( file == (void*)0xFFFFFFFF )
		return 1;
	unsigned long fsize = GetFileSize(file,NULL);
	if ( fsize < 54 )
		return 2;
	unsigned long bytes;
	ReadFile(file,header,54,&bytes,NULL);
	width = *(int*)(header+0x12);
	height =*(int*)(header+0x16);
	if ( !(width & 3) ){
		data = (unsigned char *)malloc(width*height*4);
		ReadFile(file,data,width*height*3,&bytes,NULL);
		CloseHandle(file);
	} else {
		data = (unsigned char *)malloc(width*height*4);
		unsigned char * unaligned =(unsigned char *)malloc(fsize-54);
		ReadFile(file,unaligned,fsize-54,&bytes,NULL);
		CloseHandle(file);
		for ( int h=0;h<height;h++){
			memcpy(data+h*width*3,unaligned+h*((width*3+3)&(~3)),width*3);
		}
		free(unaligned);
	}
	

	return 0;
}
